/**
  ******************************************************************************
  * @file    project.h 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   master include file for the project
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 


#ifndef PROJECT_H
#define PROJECT_H

#ifndef false
#define false 0
#define true 1
#endif

// This macro will be called whenever a condition is encountered that is not possible within the defined control flow. Must be implemented platform
// and environment dependent but should kick in only during debugging!

#define STATIC_SANITY_CHECK __asm volatile("bkpt \n")

#include "freertos.h"
#include "queue.h"
#include "semphr.h"
#include "task.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tcpip.h"
#include "fsl_os_abstraction.h" // only for ethernetif.h because the driver supplied by NXP/Freescale relies on fsl abstractions...
#include "ethernetif.h"
#include "lwip/inet.h"
#include "lwip/sockets.h"


#endif

